#ifndef NASCCL_Uninitialize_Cpp
#define NASCCL_Uninitialize_Cpp
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
    The UninitializeCryptographySet function is used to remove the Key, Size Of Key,
    encryption attributes, MValue, Matrix, InData, & OutData from memory.

    This function should be called after every "Set" of data you wish to Encode / Decode.
*/
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>

#include "NASCCL.H"
#include "sBoxes.H"
#include "Math.H"

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool NASCCL::UninitializeCryptographySet(void)
{
    memset(&MValue, 0, sizeof(MValue));
    memset(&Matrix, 0, sizeof(Matrix));

    free(KeyHash);

    KeyHashLen  = 0;
    Attribute   = 0;
    KeyHashPos  = 0;

    KeyHash     = NULL;

    return true;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

